<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InviteCeremonie extends Model 
{

    protected $table = 'invite_ceremonie';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('invite_id', 'ceremonie_id', 'status');
    protected $visible = array('invite_id', 'ceremonie_id', 'status');

    public function invite()
    {
        return $this->belongsTo('App\Models\Invite', 'invite_id');
    }

    public function ceremonie()
    {
        return $this->belongsTo('App\Models\Ceremonie', 'ceremonie_id');
    }

}